onEvent('ponder.tag', event => {
	event.createTag(
		'kubejs:iaf_forge_fire',
		'iceandfire:dragonforge_fire_core_disabled',
		'龙炎锻炉',
		'锻炉', [
		'iceandfire:dragonforge_fire_input',
		'iceandfire:dragonforge_fire_brick',
	])
})

onEvent('ponder.registry', event => {
	event.create('iceandfire:dragonforge_fire_core_disabled')
		.scene(
			'iceandfire:dragonforge',
			'龙息锻炉搭建',
			'kubejs:dragonforge',
			(scene) => {
				scene.showStructure()
				scene.idle(20)

				// 设置龙骨块的辅助函数
				const setDragonBoneBlocks = (positions) => {
					positions.forEach(pos => scene.world.setBlocks(pos, 'iceandfire:dragon_bone_block'))
				}

				// 设置锻炉砖块的辅助函数
				const setForgeFireBricks = (positions) => {
					positions.forEach(pos => scene.world.setBlocks(pos, 'iceandfire:dragonforge_fire_brick'))
				}

				// 第一层
				scene.addKeyframe()
				setDragonBoneBlocks([
					[3, 1, 3], [1, 1, 3], [3, 1, 1], [1, 1, 1]
				])
				scene.text(20, '先在四个角放上四个龙骨块')
				scene.idle(40)

				setForgeFireBricks([
					[2, 1, 3], [3, 1, 2], [2, 1, 2], [1, 1, 2], [2, 1, 1]
				])
				scene.text(20, '然后中间填充锻炉砖块')
				scene.idle(40)

				// 第二层
				scene.addKeyframe()
				setForgeFireBricks([
					[3, 2, 3], [2, 2, 3], [1, 2, 3], [3, 2, 2], [1, 2, 2], [3, 2, 1], [1, 2, 1]
				])
				scene.text(40, '这里用锻炉砖块围一下')
				scene.idle(40)

				scene.world.setBlocks([2, 2, 2], 'iceandfire:dragonforge_fire_core_disabled')
				scene.world.setBlocks([2, 2, 1], 'iceandfire:dragonforge_fire_input')
				scene.text(40, '中间放上锻炉核心\n外边放锻炉孔')
				scene.idle(40)

				// 第三层
				scene.addKeyframe()
				setDragonBoneBlocks([
					[3, 3, 3], [1, 3, 3], [3, 3, 1], [1, 3, 1]
				])
				scene.text(20, '和第一层一样,先在四个角放上四个龙骨块')
				scene.idle(40)

				setForgeFireBricks([
					[2, 3, 3], [3, 3, 2], [2, 3, 2], [1, 3, 2], [2, 3, 1]
				])
				scene.text(20, '然后中间填充锻炉砖块')

				// 替换
				scene.world.modifyBlock([2, 2, 2], () => Block.id('iceandfire:dragonforge_fire_core'), true)
				scene.world.setBlocks([1, 2, 2], Block.id('iceandfire:dragonforge_fire_brick')
					.with('grill', 'true'), true)
				scene.world.setBlocks([2, 2, 3], Block.id('iceandfire:dragonforge_fire_brick')
					.with('grill', 'true'), true)
				scene.world.setBlocks([3, 2, 2], Block.id('iceandfire:dragonforge_fire_brick')
					.with('grill', 'true'), true)
			})
})